import { getLocationErrorMessage, validateLocation } from './locationValidation';

/**
 * Test function to validate location with specific coordinates
 * This function can be called from the browser console for testing
 */
export const testLocationValidation = async (latitude = 21.40746, longitude = 50) => {
  console.log(`Testing location validation for coordinates: ${latitude}, ${longitude}`);
  
  try {
    const result = await validateLocation(latitude, longitude);
    
    console.log('Validation Result:', result);
    
    if (result.isValid) {
      console.log('✅ Location is valid for service');
      if (result.branch) {
        console.log('📍 Nearest Branch:', result.branch.branchName || result.branch.branchArName);
        console.log('📞 Branch Phone:', result.branch.phone1);
        console.log('📧 Branch Email:', result.branch.email);
        console.log('🕒 Working Hours:', result.branch.workingHoures);
      }
    } else {
      console.log('❌ Location is not valid for service');
      console.log('Error:', result.error);
      console.log('Message:', result.message);
      
      const errorMessage = getLocationErrorMessage(result, 'ar');
      console.log('Arabic Error Message:', errorMessage);
    }
    
    return result;
  } catch (error) {
    console.error('❌ Test failed with error:', error);
    return null;
  }
};

// Make it available globally for testing
if (typeof window !== 'undefined') {
  window.testLocationValidation = testLocationValidation;
}
