// store/features/shared/sharedSlice.js
import { createAsyncThunk, createSlice } from "@reduxjs/toolkit";
import { URL } from '../../constants/api';

export const fetchSharedData = createAsyncThunk(
  "shared/fetchSharedData",
  async (_, { rejectWithValue }) => {
    try {
      const res = await fetch(URL(`/share/alldata?membershipId=${localStorage.getItem('membershipId') || '0'}`));
      const data = await res.json();

      if (!res.ok || !data.status) {
        return rejectWithValue(data.message || "Failed to fetch shared data");
      }

      return data.data;
    } catch (error) {
      return rejectWithValue("Network error");
    }
  }
);

const sharedSlice = createSlice({
  name: "shared",
  initialState: {
    data: null,
    contact: null,
    carBrands: [],
    carModels: [],
    carTypes: [],
    carYears: [],
    city: null,
    branch: [],
    settings: null,
    membership: null,
    memberships: [],

    loading: false,
    error: null,
  },
  reducers: {},
  extraReducers: (builder) => {
    builder
      .addCase(fetchSharedData.fulfilled, (state, action) => {
        state.loading = false;

        state.branch = action.payload.branch;
        state.contact = action.payload.contacts[0];
        state.carBrands = action.payload.carBrands;
        state.carCategories = action.payload.carCategories;
        state.carModels = action.payload.carModels;
        state.carTypes = action.payload.carTypes;
        state.carYears = action.payload.carYears;
        state.city = action.payload.city;
        state.settings = action.payload.settings;
        state.membership = action.payload.membership;
        state.memberships = action.payload.memberships;

        state.data = action.payload;
      })
      .addCase(fetchSharedData.pending, (state) => {
        state.loading = true;
        state.error = null;
      })
      .addCase(fetchSharedData.rejected, (state, action) => {
        state.loading = false;
        state.error = action.payload;
      });
  },
});

export default sharedSlice.reducer;
