// في: src/store/features/validation/validationSlice.js

import { createSlice } from '@reduxjs/toolkit';

const initialState = {
  priceDetails: null,
  firstReservation: false,
  payload: null,
  carData: {},
  loading: false,
  error: null,
};

const validationSlice = createSlice({
  name: 'validation',
  initialState,
  reducers: {
    setPriceDetails: (state, action) => {
      state.priceDetails = action.payload;
    },
    setPayload: (state, action) => {
      // ✅ Merge مع الـ payload القديم عشان نحتفظ بالنقاط
      state.payload = {
        ...state.payload,
        ...action.payload
      };
    },
    setPoints: (state, action) => {
      // ✅ تحديث النقاط مع الحفاظ على باقي البيانات
      state.payload = {
        ...state.payload,
        points: action.payload
      };
    },
    setCarData: (state, action) => {
      state.carData = action.payload;
    },
    setFirstReservation: (state, action) => {
      state.firstReservation = action.payload;
    },
    setLoading: (state, action) => {
      state.loading = action.payload;
    },
    setError: (state, action) => {
      state.error = action.payload;
    },
    clearValidationData: (state) => {
      state.priceDetails = null;
      state.payload = null;
      state.carData = {};
      state.firstReservation = false;
      state.loading = false;
      state.error = null;
    },
  },
});

export const { setPriceDetails, setPayload, setPoints, setLoading, setError, setCarData, setFirstReservation, clearValidationData } = validationSlice.actions;
export default validationSlice.reducer;
