import { createSlice } from '@reduxjs/toolkit';

const initialState = {
  receptionData: null,
  bookingLimData: null,
  carLimData: {},
  reservationPriceLimResult: {},
};

const limousineSlice = createSlice({
  name: 'limousine',
  initialState,
  reducers: {
    setReceptionData: (state, action) => {
      state.receptionData = action.payload;
    },
    setBookingLimData: (state, action) => {
      state.bookingLimData = action.payload;
    },
    setReservationLimPriceResult: (state, action) => {
      state.reservationPriceLimResult = action.payload;
    },
    setCarLimData: (state, action) => {
      state.carLimData = action.payload;
    },
    clearLimousineData: (state) => {
      state.receptionData = null;
      state.bookingLimData = null;
      state.carLimData = {};
      state.reservationPriceLimResult = {};
    },
  },
});

export const { setCarLimData, setReceptionData, setBookingLimData, setReservationLimPriceResult, clearLimousineData } = limousineSlice.actions;
export default limousineSlice.reducer;
