import { URL } from '../constants/api';

export const fetchCar = async (filterParams = {}) => {
  // بناء query parameters من الـ filter
  const queryParams = new URLSearchParams();
  
  // إضافة جميع المعاملات المطلوبة للـ API
  if (filterParams.cityId) {
    queryParams.append('cityId', filterParams.cityId);
  }
  
  if (filterParams.branchId) {
    queryParams.append('branchId', filterParams.branchId);
  }
  
  if (filterParams.typeIds && filterParams.typeIds.length > 0) {
    filterParams.typeIds.forEach(id => queryParams.append('typeIds', id));
  }
  
  if (filterParams.datingType) {
    queryParams.append('datingType', filterParams.datingType);
  }
  
  if (filterParams.startDate) {
    queryParams.append('startDate', filterParams.startDate);
  }
  
  if (filterParams.endDate) {
    queryParams.append('endDate', filterParams.endDate);
  }
  
  if (filterParams.minPrice) {
    queryParams.append('minPrice', filterParams.minPrice);
  }
  
  if (filterParams.maxPrice) {
    queryParams.append('maxPrice', filterParams.maxPrice);
  }
  
  if (filterParams.sort) {
    queryParams.append('sort', filterParams.sort);
  }
  
  if (filterParams.carName) {
    queryParams.append('carName', filterParams.carName);
  }
  
  if (filterParams.showHome) {
    queryParams.append('showHome', filterParams.showHome);
  }
  
  // if (filterParams.page) {
  //   queryParams.append('page', filterParams.page);
  // }
  
  // if (filterParams.size) {
  //   queryParams.append('size', filterParams.size);
  // }

  const url = URL(`/car/filter?page=0&size=100${queryParams.toString() ? `&${queryParams.toString()}` : ''}`);
  
  const res = await fetch(url, {
    cache: "no-store",
  });

  if (!res.ok) throw new Error("Failed to fetch");

  const data = await res.json(); 
  return data.content;
}; 