import { URL } from '../constants/api';

export async function fetchAboutData() {
  try {
    const res = await fetch(URL('/about/find'), {
      method: 'GET',
      headers: {
        'Content-Type': 'application/json',
      },
      next: { revalidate: 3600 }, // optional for caching
    });

    const result = await res.json();
    
    if (!res.ok || !result.status) {
      throw new Error(result.message || 'Failed to fetch about data');
    }

    return result.data;
  } catch (error) {
    // Error fetching about data
    return null;
  }
}
