import cookieStorage from '@/utils/cookieStorage';
import { URL } from '../constants/api';

export const checkApi = async (endpoint) => {
  const url = URL(endpoint);
  const token = cookieStorage.getItem('token');

  if (!token) {
    return null;
  }

  try {
    const response = await fetch(url, { 
      cache: 'no-store', 
      headers: { 
        'Authorization': `Bearer ${token}`,
        'Content-Type': 'application/json'
      } 
    }); 
    
    if (!response.ok) {
      if (response.status === 401 || response.status === 403) {
        // Optionally clear invalid token
        // cookieStorage.removeItem('token');
      }
      return null;
    }

    const result = await response.json();
    
    return result.data || result;
  } catch (error) {
    return null;
  }
};


// Check if license is not expired
export const isLicenseValid = (licenseExpiration) => {
  // If licenseExpiration is null, return true (no expiration check needed)
  if (licenseExpiration == null) return true;

  // If licenseExpiration is undefined or empty string, return false
  if (!licenseExpiration) return false;

  const currentDate = new Date();
  const expirationDate = new Date(licenseExpiration);

  // License is valid if expiration date is in the future
  return expirationDate > currentDate;
};
