
import { AUTH_URL } from '@/constants/api';
import { createAsyncThunk, createSlice } from '@reduxjs/toolkit';

export let register = createAsyncThunk('register/CreateAccount  ', async (payload, { rejectWithValue }) => {
    try {
        const url = AUTH_URL('/signup'); 

        
        const response = await fetch(url, {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify(payload),
        });

        const data = await response.json();

        // ✅ Check correct success
        if (!response.ok || data.status !== true || data.message !== "SUCCESS") {
            return rejectWithValue(data.message || "Register failed");
        }

        return data;
    } catch (error) {
        return rejectWithValue(error.message || "Network error");
    }
}
);


let initialState = {
    data: [],
    loading: false,
    error: null,
}
let signupSlice = createSlice({
    name: 'register',
    initialState,
    extraReducers: (builder => {
        builder
            .addCase(register.fulfilled, (state, action) => {
                state.data = action.payload;
                state.loading = false
            })
            .addCase(register.pending, (state) => {
                state.loading = true
            })
            .addCase(register.rejected, (state, action) => {
                state.loading = false;
                state.error = action.payload || "فشل في التسجيل";
            })

    })
})

export let signupReducer = signupSlice.reducer