// src/lib/auth/loginSlice.js
import { AUTH_URL } from '@/constants/api';
import { createAsyncThunk, createSlice } from '@reduxjs/toolkit';

export const login = createAsyncThunk(
  'login/login',
  async ({ username, password }, { rejectWithValue }) => {
    try {
      const response = await fetch(AUTH_URL('/client/login'), {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({ username, password }),
      });

      const data = await response.json();

      if (!response.ok || data.status !== true || data.message !== "SUCCESS") {
        return rejectWithValue(data.message || "Login failed");
      }

      return data.data;
    } catch (error) {
      return rejectWithValue("Network error");
    }
  }
);

const loginSlice = createSlice({
  name: 'login',
  initialState: {
    user: null,
    token: null,
    loading: false,
    error: null,
  },
  reducers: {
    logout: (state) => {
      state.user = null;
      state.token = null;
    }
  },
  extraReducers: (builder) => {
    builder
      .addCase(login.pending, (state) => {
        state.loading = true;
        state.error = null;
      })
      .addCase(login.fulfilled, (state, action) => {
        state.loading = false;
        state.user = action.payload;
        state.token = action.payload.bearerToken;
      })
      .addCase(login.rejected, (state, action) => {
        state.loading = false;
        state.error = action.payload;
      });
  },
});

export const { logout } = loginSlice.actions;
export let loginReducer = loginSlice.reducer;
