import cookieStorage from '@/utils/cookieStorage';
import { URL } from '../constants/api';

export const apiPost = async (endpoint, options = {}) => {
    const token = cookieStorage.getItem('token');

    const defaultHeaders = {
        'Content-Type': 'application/json',
        ...(token && { Authorization: `Bearer ${token}` }),
    };

    const config = {
        ...options,
        headers: {
            ...defaultHeaders,
            ...(options.headers || {}),
        },
    };

    try {
        const fullUrl = URL(endpoint);
        
        const res = await fetch(fullUrl, config);
        const result = await res.json(); 

        if (!res.ok) {
            // API Error
            throw new Error(result.message || 'API Error');
        }

        return result;
    } catch (error) {
        // apiPost error
        throw error;
    }
};
