// lib/api.js
export async function getBlogs(lang) {
  const res = await fetch(`https://vigtas.live/gazalservices/blogs?lang=${lang}`, {
    cache: 'default', // Enable ISR (optional)
  });

  if (!res.ok) {
    throw new Error('Failed to fetch blogs');
  }

  return res.json();
}
export async function getBlogById(id, lang) {
  const res = await fetch(`https://vigtas.live/gazalservices/blogs/${id}?lang=${lang}`, {
    cache: 'no-store', // Disable caching for this request
  });

  if (!res.ok) {
    throw new Error('Failed to fetch blog');
  }

  return res.json();
}

