// hooks/useRestorePriceDetails.js
import cookieStorage from '@/utils/cookieStorage';
import { setBookingLimData, setCarLimData, setReceptionData, setReservationLimPriceResult } from '@store/features/lim/limousineSlice';
import { setRentalCarData, setSavedEndDate, setSavedStartDate, setSavedStartTime, setSelectedBranchId, setSelectedCityId } from '@store/features/rental/rentalSlice';
import { setPayload, setPriceDetails } from '@store/features/validation/booking/validationSlice';
import { useEffect } from 'react';
import { useDispatch } from 'react-redux';

export const useRestore = () => {
    const dispatch = useDispatch();

    useEffect(() => {
        const storedPriceDetails = cookieStorage.getItem('priceDetails');
        const storedPayload = cookieStorage.getItem('payloadReservation');
        const storedLim = cookieStorage.getItem('receptionData');
        const bookingLim = cookieStorage.getItem('bookingLim');
        const reservationPriceLimResult = cookieStorage.getItem('reservationPriceLimResult');
        const rentalData = cookieStorage.getItem('rentalData');

        if (storedPriceDetails) {
            dispatch(setPriceDetails(JSON.parse(storedPriceDetails)));
        }

        if (rentalData) {
            const parsedRentalData = JSON.parse(rentalData);
            dispatch(setRentalCarData(parsedRentalData));
            
            // استرجاع بيانات الفرع والمدينة المحفوظة من الجلسة
            if (parsedRentalData.branchId) {
                dispatch(setSelectedBranchId(parsedRentalData.branchId));
            }
            if (parsedRentalData.cityId) {
                dispatch(setSelectedCityId(parsedRentalData.cityId));
            }
            
            // استرجاع بيانات التاريخ والوقت المحفوظة من الجلسة
            if (parsedRentalData.startDate) {
                dispatch(setSavedStartDate(parsedRentalData.startDate));
            }
            if (parsedRentalData.endDate) {
                dispatch(setSavedEndDate(parsedRentalData.endDate));
            }
            if (parsedRentalData.startTime) {
                dispatch(setSavedStartTime(parsedRentalData.startTime));
            }
        }

        if (storedPayload) {
            dispatch(setPayload(JSON.parse(storedPayload)));
        }

        if (storedLim) {
            dispatch(setReceptionData(JSON.parse(storedLim)));
        }

        if (bookingLim) {
            const parsedBookingLim = JSON.parse(bookingLim);
            dispatch(setBookingLimData(parsedBookingLim));
        }
        if (reservationPriceLimResult) {
            dispatch(setReservationLimPriceResult(JSON.parse(reservationPriceLimResult)));
        }

        const carLimData = cookieStorage.getItem('carLimData');
        if (carLimData) {
            dispatch(setCarLimData(JSON.parse(carLimData)));
        }


    }, [dispatch]); 
};
