'use client';
import { URL } from '@/constants/api';
import { useEffect, useState } from 'react';

const useMembershipData = () => {
    const [memberships, setMemberships] = useState([]);
    const [loading, setLoading] = useState(true);
    const [error, setError] = useState(null);

    useEffect(() => {
        const fetchMemberships = async () => {
            try {
                setLoading(true);
                const response = await fetch(URL('/memberships/findall'));

                const result = await response.json();

                if (result.status) {
                    setMemberships(result.data.content);
                } else {
                    setMemberships([]);
                }
            } catch (err) {
                // Error fetching memberships
                setError(err.message);
                setMemberships([]);
            } finally {
                setLoading(false);
            }
        };

        fetchMemberships();
    }, []);

    return { memberships, loading, error };
};

export default useMembershipData;
