'use client';

import { notification } from 'antd';
import { useLocale, useTranslations } from 'next-intl';
import { URL } from '../constants/api';

const useCarAvailabilityCheck = () => {
    let t = useTranslations('validation')
    let locale = useLocale();
    const checkCarAvailability = async ({ carId, branchId }) => {
        try {
            if (!carId || !branchId) return true;

            const res = await fetch(URL(`/car_branch/availability/branch/${branchId}/car/${carId}`));
            const result = await res.json();

            if (result.data == false) {
                // إرجاع false بدلاً من إظهار notification مباشرة
                // سيتم التعامل مع هذا في المكون الذي يستدعي الدالة
                return false;
            } else {
                return true;
            }

        } catch (error) {
            notification.error({
                message: t('ERROR_TITLE'),
                description: t('CAR_AVAILABILITY_CHECK_FAILED'),
                placement: locale == 'en' ? 'topLeft' : 'topRight',
            });

            return false;
        }
    };

    return { checkCarAvailability };
};

export default useCarAvailabilityCheck;
