// hook/useBranchesByCity.js
'use client';

import { useCallback, useEffect, useState } from 'react';
import { URL } from '../constants/api';

const useBranchesByCity = (selectedCityId) => {
  const [branches, setBranches] = useState([]);
  const [loading, setLoading] = useState(false);
  const [error, setError] = useState(null);

  const fetchBranches = useCallback(async (cityId) => {
    if (!cityId) {
      setBranches([]);
      setError(null);
      return;
    }

    setLoading(true);
    setError(null);
    
    try {
      const url = URL(`/branch/find/city/${cityId}`);
      const response = await fetch(url);
      
      if (!response.ok) {
        throw new Error(`HTTP error! status: ${response.status}`);
      }
      
      const { data } = await response.json();
      setBranches(data || []);
    } catch (error) {
      // Error fetching branches
      setError(error.message);
      setBranches([]);
    } finally {
      setLoading(false);
    }
  }, []);

  useEffect(() => {
    fetchBranches(selectedCityId);
  }, [selectedCityId, fetchBranches]);

  const refetch = useCallback(() => {
    fetchBranches(selectedCityId);
  }, [fetchBranches, selectedCityId]);

  return {
    branches,
    loading,
    error,
    refetch
  };
};

export default useBranchesByCity; 