import { useEffect, useState } from 'react';

const useLimData = (url, body) => {
  const [data, setData] = useState([]);
  const [loading, setLoading] = useState(true);
  const [error, setError] = useState(null); // Optional

  useEffect(() => {
    const fetchData = async () => {
      setLoading(true);
      setError(null);
      try {
        const res = await fetch(url, {
          method: 'POST',
          headers: {
            'Content-Type': 'application/json',
          },
          body: JSON.stringify(body),
        });

        if (!res.ok) throw new Error('فشل تحميل البيانات');

        const result = await res.json();
        setData(result || []);
      } catch (err) {
        setError(err.message || 'Unknown error');
        setData([]);
      } finally {
        setLoading(false);
      }
    };

    if (url && body) fetchData();
  }, [url, JSON.stringify(body)]); // Re-fetch on url or body change

  return { data, loading, error };
};

export default useLimData;
