import { showCustomNotification } from './customNotification';

// دالة لاختبار الإشعار المخصص
export const testCustomNotification = () => {
  showCustomNotification({
    title: 'حجزك جاهزاً! تفاصيل الحجز موجودة في حسابك',
    description: 'يمكنك مراجعة تفاصيل الحجز من خلال حسابك الشخصي',
    icon: '🚗',
    duration: 8000
  });
};

// إضافة الدالة للنافذة العامة للاختبار
if (typeof window !== 'undefined') {
  window.testCustomNotification = testCustomNotification;
}

// أمثلة مختلفة للإشعارات
export const showBookingNotification = () => {
  showCustomNotification({
    title: 'حجزك جاهزاً! تفاصيل الحجز موجودة في حسابك',
    description: 'رقم الحجز: #12345',
    icon: '🚗',
    duration: 8000
  });
};

export const showWelcomeNotification = () => {
  showCustomNotification({
    title: 'مرحباً بك في الغزال',
    description: 'تم إنشاء حسابك بنجاح',
    icon: '🎉',
    duration: 6000
  });
};

export const showPaymentNotification = () => {
  showCustomNotification({
    title: 'تم الدفع بنجاح',
    description: 'تم تأكيد عملية الدفع',
    icon: '💳',
    duration: 5000
  });
};

// إضافة جميع الدوال للنافذة العامة
if (typeof window !== 'undefined') {
  window.showBookingNotification = showBookingNotification;
  window.showWelcomeNotification = showWelcomeNotification;
  window.showPaymentNotification = showPaymentNotification;
}
