import img from "@/constants/img";
import Image from "next/image";

const NotificationComponent = ({ title, description, icon = '🚗', onClose }) => {
  return (
    <div 
      style={{
        position: 'fixed',
        top: '20px',
        left: '50%',
        transform: 'translateX(-50%)',
        zIndex: 9999,
        minWidth: '400px',
        maxWidth: '500px',
        backgroundColor: '#ffffff',
        border: '2px solid #2c5530',
        borderRadius: '12px',
        boxShadow: '0 8px 25px rgba(44, 85, 48, 0.2)',
        padding: '0', 
        animation: 'slideDown 0.3s ease-out'
      }}
      
    >
      {/* محتوى الإشعار */}
      <div style={{ display: 'flex', alignItems: 'center', padding: '16px' }}>
        {/* الأيقونة الدائرية */}
        <div 
          style={{
            width: '60px',
            height: '60px',
            backgroundColor: '#162A2B',
            borderRadius: '50%',
            display: 'flex',
            alignItems: 'center',
            justifyContent: 'center',
            marginLeft: '12px',
            flexShrink: 0
          }}
        >
          <span style={{ 
            color: 'white', 
            fontSize: '24px',
            fontWeight: 'bold'
          }}>
            <Image src={img.logo} alt="icon" width={40} height={40} />
          </span>
        </div>

        {/* النص */}
        <div style={{ flex: 1, textAlign: 'right' }}>
          <div style={{
            fontSize: '16px',
            fontWeight: 'bold',
            color: '#2c5530',
            marginBottom: description ? '4px' : '0',
            lineHeight: '1.4'
          }}>
            {title}
          </div>
          {description && (
            <div style={{
              fontSize: '14px',
              color: '#666',
              lineHeight: '1.3'
            }}>
              {description}
            </div>
          )}
        </div>

        {/* زر الإغلاق */}
        <button
          onClick={onClose}
          style={{
            position: 'absolute',
            top: '8px',
            left: '8px',
            background: 'none',
            border: 'none',
            fontSize: '20px',
            color: '#999',
            cursor: 'pointer',
            width: '24px',
            height: '24px',
            display: 'flex',
            alignItems: 'center',
            justifyContent: 'center',
            borderRadius: '50%',
            transition: 'all 0.2s'
          }}
          onMouseOver={(e) => {
            e.target.style.backgroundColor = '#f0f0f0';
            e.target.style.color = '#2c5530';
          }}
          onMouseOut={(e) => {
            e.target.style.backgroundColor = 'transparent';
            e.target.style.color = '#999';
          }}
        >
          ×
        </button>
      </div>

      <style jsx>{`
        @keyframes slideDown {
          from {
            opacity: 0;
            transform: translateX(-50%) translateY(-20px);
          }
          to {
            opacity: 1;
            transform: translateX(-50%) translateY(0);
          }
        }
      `}</style>
    </div>
  );
};

export default NotificationComponent;
