'use client';
import { useRouter } from '@/navigation';
import { message } from 'antd';
import { useTranslations } from 'next-intl';
import { useEffect, useRef } from 'react';

export function useAuthGuard(redirectTo = '/login') {
  const router = useRouter();
  const tVal = useTranslations();
  const shownRef = useRef(false); // ✅ لتجنب التكرار

  useEffect(() => {
    // التحقق من sessionStorage أولاً
    const messageKey = 'auth_guard_message_shown';
    const hasShown = sessionStorage.getItem(messageKey);
    
    if (hasShown || shownRef.current) {
      return; // تم العرض مسبقاً
    }

    const cookies = document.cookie.split('; ').reduce((acc, curr) => {
      const [name, value] = curr.split('=');
      acc[name] = value;
      return acc;
    }, {});

    if (!cookies.token) {
      // تعيين العلامات قبل عرض الرسالة لتجنب التكرار
      shownRef.current = true;
      sessionStorage.setItem(messageKey, 'true');
      
      message.error(tVal('please_login_to_use'));
      router.push(redirectTo);
      
      // تنظيف sessionStorage بعد 2 ثانية
      setTimeout(() => {
        sessionStorage.removeItem(messageKey);
      }, 2000);
    }
  }, [router, tVal, redirectTo]);
}
