// دالة لتحويل التاريخ إلى التنسيق المطلوب للـ sitemap
function formatSitemapDate(date) {
  if (!date) return new Date().toISOString().replace(/\.\d{3}Z$/, '+00:00');
  
  const dateObj = date instanceof Date ? date : new Date(date);
  return dateObj.toISOString().replace(/\.\d{3}Z$/, '+00:00');
}

export default async function sitemap() {
  const baseUrl = 'https://www.alghazal.sa';
  const currentDate = formatSitemapDate(new Date());

  // روابط الصفحات الثابتة
  const staticPages = [
    // الصفحة الرئيسية
    {
      url: baseUrl,
      lastModified: currentDate,
      changeFrequency: 'daily',
      priority: 1.0,
    },
    {
      url: `${baseUrl}/ar`,
      lastModified: currentDate,
      changeFrequency: 'daily',
      priority: 1.0,
    },
    {
      url: `${baseUrl}/en`,
      lastModified: currentDate,
      changeFrequency: 'daily',
      priority: 1.0,
    },
    
    // صفحات المتجر والسيارات
    {
      url: `${baseUrl}/ar/cars`,
      lastModified: currentDate,
      changeFrequency: 'daily',
      priority: 0.9,
    },
    {
      url: `${baseUrl}/en/cars`,
      lastModified: currentDate,
      changeFrequency: 'daily',
      priority: 0.9,
    },
    
    // صفحة اللينو
    {
      url: `${baseUrl}/ar/limo`,
      lastModified: currentDate,
      changeFrequency: 'daily',
      priority: 0.9,
    },
    {
      url: `${baseUrl}/en/limo`,
      lastModified: currentDate,
      changeFrequency: 'daily',
      priority: 0.9,
    },
    
    // صفحات حولنا
    {
      url: `${baseUrl}/ar/about`,
      lastModified: currentDate,
      changeFrequency: 'monthly',
      priority: 0.8,
    },
    {
      url: `${baseUrl}/en/about`,
      lastModified: currentDate,
      changeFrequency: 'monthly',
      priority: 0.8,
    },
    
    // صفحة الفروع
    {
      url: `${baseUrl}/ar/branches`,
      lastModified: currentDate,
      changeFrequency: 'weekly',
      priority: 0.8,
    },
    {
      url: `${baseUrl}/en/branches`,
      lastModified: currentDate,
      changeFrequency: 'weekly',
      priority: 0.8,
    },
    
    // صفحة العضوية
    {
      url: `${baseUrl}/ar/membership`,
      lastModified: currentDate,
      changeFrequency: 'monthly',
      priority: 0.7,
    },
    {
      url: `${baseUrl}/en/membership`,
      lastModified: currentDate,
      changeFrequency: 'monthly',
      priority: 0.7,
    },
    
    // صفحة اتصل بنا
    {
      url: `${baseUrl}/ar/contactus`,
      lastModified: currentDate,
      changeFrequency: 'monthly',
      priority: 0.7,
    },
    {
      url: `${baseUrl}/en/contactus`,
      lastModified: currentDate,
      changeFrequency: 'monthly',
      priority: 0.7,
    },
    
    // صفحة المدونة
    {
      url: `${baseUrl}/ar/blogs`,
      lastModified: currentDate,
      changeFrequency: 'weekly',
      priority: 0.8,
    },
    {
      url: `${baseUrl}/en/blogs`,
      lastModified: currentDate,
      changeFrequency: 'weekly',
      priority: 0.8,
    },

    // مقالات المدونة (Dynamic)
    ...(await getBlogPages(baseUrl)),
    
    // صفحة تسجيل الدخول
    {
      url: `${baseUrl}/ar/login`,
      lastModified: currentDate,
      changeFrequency: 'monthly',
      priority: 0.5,
    },
    {
      url: `${baseUrl}/en/login`,
      lastModified: currentDate,
      changeFrequency: 'monthly',
      priority: 0.5,
    },
    
    // صفحة إنشاء حساب
    {
      url: `${baseUrl}/ar/sign-up`,
      lastModified: currentDate,
      changeFrequency: 'monthly',
      priority: 0.5,
    },
    {
      url: `${baseUrl}/en/sign-up`,
      lastModified: currentDate,
      changeFrequency: 'monthly',
      priority: 0.5,
    },
    
    // صفحة سياسة الخصوصية
    {
      url: `${baseUrl}/ar/privacy-policy`,
      lastModified: currentDate,
      changeFrequency: 'yearly',
      priority: 0.3,
    },
    {
      url: `${baseUrl}/en/privacy-policy`,
      lastModified: currentDate,
      changeFrequency: 'yearly',
      priority: 0.3,
    },
    
    // صفحة شروط الاستخدام
    {
      url: `${baseUrl}/ar/terms-of-use`,
      lastModified: currentDate,
      changeFrequency: 'yearly',
      priority: 0.3,
    },
    {
      url: `${baseUrl}/en/terms-of-use`,
      lastModified: currentDate,
      changeFrequency: 'yearly',
      priority: 0.3,
    },
  ];

  return staticPages;
}

// دالة لجلب مقالات المدونة من API
async function getBlogPages(baseUrl) {
  try {
    const res = await fetch(`https://viganium.me/api/blog/findall?page=0&size=1000`, {
      next: { revalidate: 3600 } // تحديث كل ساعة
    });

    if (!res.ok) {
      return [];
    }

    const response = await res.json();
    
    if (!response.status || !response.data || !response.data.content) {
      return [];
    }

    const blogs = response.data.content;
    const currentDate = formatSitemapDate(new Date());
    const blogPages = [];

    blogs.forEach((blog) => {
      // المقال بالعربية
      if (blog.slugAr) {
        blogPages.push({
          url: `${baseUrl}/ar/blogs/${blog.blogId}/${blog.slugAr}`,
          lastModified: formatSitemapDate(blog.updatedAt || blog.publishedAt || currentDate),
          changeFrequency: 'weekly',
          priority: 0.8,
        });
      }

      // المقال بالإنجليزية
      if (blog.slug) {
        blogPages.push({
          url: `${baseUrl}/en/blogs/${blog.blogId}/${blog.slug}`,
          lastModified: formatSitemapDate(blog.updatedAt || blog.publishedAt || currentDate),
          changeFrequency: 'weekly',
          priority: 0.8,
        });
      }
    });

    return blogPages;
  } catch (error) {
    console.error('Error fetching blogs for sitemap:', error);
    return [];
  }
}

