export default async function blogsSitemap() {
  const baseUrl = 'https://www.alghazal.sa';
  
  try {
    // جلب جميع المقالات من API
    const res = await fetch(`https://viganium.me/api/blog/findall?page=0&size=1000`, {
      next: { revalidate: 3600 } // تحديث كل ساعة
    });

    if (!res.ok) {
      console.error('Failed to fetch blogs for blogs sitemap');
      return [];
    }

    const response = await res.json();
    
    if (!response.status || !response.data || !response.data.content) {
      return [];
    }

    const blogs = response.data.content;
    const currentDate = new Date().toISOString();

    // إنشاء sitemap entries للمقالات
    const blogPages = [];
    
    blogs.forEach((blog) => {
      // المقال بالعربية
      if (blog.slugAr) {
        blogPages.push({
          url: `${baseUrl}/ar/blogs/${blog.blogId}/${blog.slugAr}`,
          lastModified: blog.updatedAt || blog.publishedAt || currentDate,
          changeFrequency: 'weekly',
          priority: 0.8,
        });
      }

      // المقال بالإنجليزية
      if (blog.slug) {
        blogPages.push({
          url: `${baseUrl}/en/blogs/${blog.blogId}/${blog.slug}`,
          lastModified: blog.updatedAt || blog.publishedAt || currentDate,
          changeFrequency: 'weekly',
          priority: 0.8,
        });
      }
    });

    return blogPages;
  } catch (error) {
    console.error('Error generating blogs sitemap:', error);
    return [];
  }
}

