// app/api/payment/callback/route.js
import { NextResponse } from "next/server";

export async function POST(req) {
  try {
    const payload = await req.json();

    // TODO: هنا سجّل الـpayload في DB/Logs
    // payload غالباً يحتوي tran_ref, cart_id, cart_amount, payment_result, customer_details, ...
    console.log("[PayTabs Callback] payload:", JSON.stringify(payload));

    // ⚠️ مهم: لا تعتمد على هذا فقط. اعمل query بالـtran_ref للتأكيد النهائي.
    // مثال (غير متزامن هنا):
    // await fetch(`${process.env.NEXT_PUBLIC_APP_URL}/api/payment/query`, { method: "POST", ... })

    return NextResponse.json({ received: true });
  } catch (err) {
    return NextResponse.json({ error: err?.message || "callback error" }, { status: 500 });
  }
}

