'use client';

import Header from '@/app/(components)/header/Header';
import { useLocale } from 'next-intl';

const PageContainer = ({
    children,
    title,
    className = '',
    containerClassName = '',
    contentClassName = '',
    pt = 'pt-[150px]',
    pb = 'pb-[50px]',
    ptContent = 'py-0',
    showBorder = true,
    showPadding = true,
    width = 'md:w-[98%] lg:w-[95%] xl:w-[95%] 2xl:w-[95%]'
}) => {
    const locale = useLocale();
    const isRTL = locale === 'ar';

    return (
        <div className={`reservation-bg-container ${pt} ${pb} ${className}`}>
            <div className={`${width} m-auto  ${containerClassName}`}>
                {showBorder ? (
                    <div className={`rounded-[8px] border border-[#DBDBDB] bg-white overflow-hidden ${contentClassName}`}>
                        <div className={`bg-white  ${!showPadding && 'p-0 '} ${showPadding && ' p-8 max-md:!p-0 ' + ptContent}`} dir={isRTL ? 'rtl' : 'ltr'}>
                            {title && (
                                <div className="mt-[0px]">
                                    <Header title={title} />
                                </div>
                            )}
                            {children}
                        </div>
                    </div>
                ) : (
                    <div className={`bg-white ${!showPadding && 'p-0'} ${showPadding && ' p-8 max-md:!p-0 '} ${contentClassName}`} dir={isRTL ? 'rtl' : 'ltr'}>
                        {title && (
                            <div className="mt-[0px]">
                                <Header title={title} />
                            </div>
                        )}
                        {children}
                    </div>
                )}
            </div>
        </div>
    );
};

export default PageContainer;
