'use client';

import { Button } from 'antd';

const OfferItemBox = ({
  icon,
  title,
  activated = false,
  onClick,
  loading = false,
  buttonText = 'احصل على العرض',
  activatedText = 'تم التفعيل',
  color = 'bg-[#162A2B1A]'
}) => {
  return (
    <div   onClick={onClick} className={`flex justify-between cursor-pointer items-center border
      ${activated ? 'bg-[#162A2B0A] border-[#d59f23]' : `${color}`}
      px-[15px] py-[10px] rounded-[5px]`}
    >
      <div className="flex items-center gap-2 max-sm:[&_svg]:w-3">
        {icon}
        <span className="text-[14px] max-sm:!text-[9px]">
          {title}
        </span>
      </div>

      <Button
        type="primary"
        onClick={onClick}
        disabled={loading}
        loading={loading} 
        className={`m-0 px-[17px] rounded-[5px] h-[28px] font-thin text-white !shadow-none
          max-sm:w-[60px] max-sm:h-[21px]
          max-sm:[&_span]:!text-[6px] [&>span]:text-[10px]
          ${activated ? '!bg-[#d59f23] border-[#d59f23] !text-[#fff] hover:!bg-[#d59f23]' : '!bg-primary'}`}
      >
        {activated ? activatedText : buttonText}
      </Button>
    </div>
  );
};

export default OfferItemBox;
