
import { Calendar } from 'antd';
import dayjs from 'dayjs';

const onPanelChange = (value, mode) => {
    // Panel changed
};

// دالة افتراضية لتعطيل التواريخ السابقة
const defaultDisabledDate = (current) => {
    // تعطيل جميع التواريخ قبل اليوم
    return current && current < dayjs().startOf('day');
};

const CustomCalendar = ({ onDateChange, selectedDate, disabledDate, maxDaysFromNow = null, LIMO = false }) => {

    const onSelect = (value) => {
        if (value && typeof value.format === 'function') {
            if (onDateChange) {
                onDateChange(value);
            }
        }
    };

    // دالة لتعطيل التواريخ بناءً على الحد الأقصى (بالساعات)
    const createMaxHoursDisabledDate = (maxHours) => {
        return (current) => {
            if (!current) return false;

            const now = dayjs();
            const maxAllowedDateTime = now.add(maxHours, 'hour');

            // تعطيل التواريخ قبل الآن أو بعد الحد الأقصى (72 ساعة)
            return current.isBefore(now, 'day') || current.isAfter(maxAllowedDateTime, 'day');
        };
    };
    // تحويل الأيام إلى ساعات
    maxDaysFromNow = !LIMO ? (maxDaysFromNow ? maxDaysFromNow * 24 : null) : maxDaysFromNow;

    // استخدام الـ disabledDate الممرر أو الافتراضي أو بناءً على maxDaysFromNow (بالساعات)
    const finalDisabledDate = disabledDate || (maxDaysFromNow ? createMaxHoursDisabledDate(maxDaysFromNow) : defaultDisabledDate);

    return (
        <Calendar
            fullscreen={false}
            onPanelChange={onPanelChange}
            onSelect={onSelect}
            // استخدام null بدلاً من undefined لضمان عدم التحديد التلقائي
            value={selectedDate ? dayjs(selectedDate) : null}
            disabledDate={finalDisabledDate}
        />
    );
};
export default CustomCalendar;