'use client';

import { CalendarOutlined, ClockCircleOutlined } from '@ant-design/icons';
import { CustomDatePicker, CustomTimePicker } from '@components/ui';
import { Col, Row } from 'antd';
import { parseISO, startOfDay } from 'date-fns';
import { useTranslations } from 'next-intl';
import { useSelector } from 'react-redux';
import FormSection from '../atoms/FormSection';

const DateTimeFields = ({ title, showTitle = true }) => {
    const t = useTranslations();
    const { receptionData } = useSelector((state) => state.limousine);

    const receptionDate = receptionData?.receptionDateTime
        ? parseISO(receptionData.receptionDateTime)
        : null;

    const initialDate = receptionDate ? startOfDay(receptionDate) : null;
    const initialTime = receptionDate ? receptionDate : null;

    return (
        <FormSection title={title || t('day_time')} showTitle={showTitle}>
            <Row gutter={[16, 0]}>
                <Col xs={24} md={24}>
                    <CustomDatePicker
                        placeholder={t("rental_start_date")}
                        suffixIcon={<CalendarOutlined />}
                        size="large" 
                        className="w-full h-[50px]"
                        name="startDate"
                        defaultValue={initialDate}
                        format="YYYY-MM-DD"
                        localeCode={'ar'}
                        required={false}
                    />
                </Col>
                <Col xs={24} md={24}>
                    <CustomTimePicker
                        name="startTime"
                        placeholder={t("rental_start_time")}
                        suffixIcon={<ClockCircleOutlined />}
                        className="w-full h-[50px]"
                        size="large"
                        format="HH:mm"
                        defaultValue={initialTime}
                        localeCode={'ar'}
                        required={false} 
                    />
                </Col>
            </Row>
        </FormSection>
    );
};

export default DateTimeFields; 