import { Radio } from 'antd';

const CustomRadioGroup = ({ 
  options = [], 
  value, 
  onChange, 
  name, 
  defaultValue, 
  className = '', 
  layout = 'vertical', // 'vertical' or 'horizontal'
  gap = 'gap-3', // gap between radio items
  ...props 
}) => {
  const isHorizontal = layout === 'horizontal';
  
  return (
    <Radio.Group
      name={name}
      value={value}
      defaultValue={defaultValue}
      onChange={onChange}
      className={`w-full ${className}`}
      {...props}
    >
      <div className={`flex ${isHorizontal ? 'flex-row' : 'flex-col'} w-full ${gap}`}>
        {options.map((option) => (
          <Radio 
            key={option.value} 
            value={option.value} 
            className="text-base"
            disabled={option.disabled}
          >
            {option.label}
          </Radio>
        ))}
      </div>
    </Radio.Group>
  );
};

export default CustomRadioGroup;
