import { Form, Input, InputNumber } from 'antd';
import { useTranslations } from 'next-intl';

const { TextArea } = Input;
const CustomInput = ({
    required = true,
    suffix,
    type = 'text',
    label = '',
    size = 'large',
    icon,
    name,
    customRules = [],
    ...props
}) => {
    let InputComponent;

    switch (type) {
        case 'password':
            InputComponent = Input.Password;
            break;
        case 'textarea':
            InputComponent = TextArea;
            break;
        case 'number':
            InputComponent = InputNumber;
            break;
        default:
            InputComponent = Input;
    }
    const t = useTranslations();
    const inputElement = <InputComponent  {...props} className={`${props.className} shadow-none rounded text-sm border-[#d9d9d9]`} size={size} suffix={suffix} />;

    return (
        <Form.Item
            name={name}
            // label={label || undefined}
            
            rules={customRules.length > 0 ? customRules : (required ? [{ required: true, message: ` ${t('required')}` }] : [])}
        >
            {inputElement}  
        </Form.Item>
    );
};

export default CustomInput;
