'use client';
import { Form, Select } from 'antd';
import { useTranslations } from 'next-intl';
import { useState } from 'react';

const CustomDropdown = ({
  reCall,
  name,
  label,
  showSearch = true,
  endpoint,
  valueKey = 'id',
  labelKey = 'title',
  placeholder = 'الرجاء الاختيار ',
  required = true,
  rules = [],
  customRules = [],
  mode = "single", // e.g., 'multiple', 'tags'
  extraOptions = [], // ✅ خيارات إضافية مثل Other Company
  options = [], // ✅ إضافة دعم للخيارات المباشرة
  ...props
}) => {
  const [data, setData] = useState([]);
  const [loading, setLoading] = useState(false);
  const t = useTranslations();
  const allOptions = [
    ...data.map(item => ({
      label: labelKey === 'name_course'
        ? `${item.name} - ${item.course_name}`
        : item[labelKey],
      value: item[valueKey],
    })),
    ...extraOptions,
    ...options // ✅ إضافة الخيارات المباشرة
  ];

  // إذا كان هناك name، استخدم Form.Item
  if (name) {
    return (
      <Form.Item
        name={name}
        // label={label}
        rules={
          customRules.length > 0
            ? customRules
            : required
              ? [{ required: true, message: `${t('required')}` }, ...rules]
              : rules
        }
        required={required}
      //  // className="custom_field" 
      >
        <Select
          loading={loading}
          placeholder={placeholder}
          aria-label={label || placeholder || (name ? `Select ${name}` : 'Select an option')}
          showSearch={showSearch}
          optionFilterProp="label"
          mode={mode}
          className={props.className}
          disabled={props.disabled}
          allowClear
          {...props}
        >
          {allOptions.map(option => (
            <Select.Option
              key={option.value}
              value={option.value}
              label={option.label}
              disabled={option.disabled}
            >
              {option.label}
            </Select.Option>
          ))}
        </Select>
      </Form.Item>
    );
  }

  // وإلا ارجع الـ Select مباشرة
  return (
    <Select
      loading={loading}
      placeholder={placeholder}
      aria-label={label || placeholder || (name ? `Select ${name}` : 'Select an option')}
      showSearch={showSearch}
      optionFilterProp="label"
      mode={mode}
      className={props.className}
      defaultValue={props.defaultValue}
      disabled={props.disabled}
      allowClear
      value={props.value}
      {...props}
    >
      {allOptions.map(option => (
        <Select.Option
          key={option.value}
          value={option.value}
          label={option.label}
          disabled={option.disabled}
        >
          {option.label}
        </Select.Option>
      ))}
    </Select>
  );
};

export default CustomDropdown;
