'use client';

import HeaderTitle from '@components/Title/HeaderTitle';
import { useTranslations } from 'next-intl';

const FormSection = ({ title, children, showTitle = true, className = "" }) => {
    const t = useTranslations();

    return (
        <div className={`reservation__content ${className}`}>
            {showTitle && (
                <HeaderTitle className="mt-5" center="text-center" title={title || t('section_title')} />
            )}
            <div className="pb-3 pt-5 px-4 rounded-b-[20px] border-main border-b-[1px] border-l-[1px] border-r-[1px]">
                {children}
            </div>
        </div>
    );
};

export default FormSection; 