# DurationSelector Component

مكون لاختيار المدة بالساعات مع تصميم radio buttons مشابه للصورة المرفقة.

## الميزات

- ✅ تصميم مطابق للصورة المرفقة
- ✅ Radio buttons مع تأثيرات بصرية
- ✅ أيقونة التقويم في العنوان
- ✅ خلفية ملونة للخيار المحدد
- ✅ تأثيرات hover متحركة
- ✅ Scrollbar مخصص
- ✅ دعم RTL
- ✅ قابل للتخصيص بالكامل

## الاستخدام

```jsx
import DurationSelector from '@ui/atoms/DurationSelector';

// الاستخدام الأساسي
<DurationSelector 
  value={5}
  onChange={(value) => console.log(value)}
/>

// مع خيارات مخصصة
<DurationSelector 
  options={[2, 4, 6, 8, 10, 12]}
  value={6}
  onChange={handleChange}
  title="اختر المدة:"
  showIcon={true}
/>
```

## Props

| Prop | Type | Default | Description |
|------|------|---------|-------------|
| `options` | number[] | [4,5,6,7,8,9,10,11,12] | قائمة الساعات المتاحة |
| `value` | number | - | القيمة المحددة |
| `onChange` | function | - | دالة التغيير |
| `title` | string | "المدة:" | عنوان المكون |
| `showIcon` | boolean | true | إظهار أيقونة التقويم |
| `disabled` | boolean | false | تعطيل المكون |
| `className` | string | "" | CSS classes إضافية |

## التكامل مع Form

```jsx
<DurationSelector
  value={form.getFieldValue('hours')}
  onChange={(value) => {
    form.setFieldsValue({ hours: value });
  }}
  title="المدة:"
/>
```

## التصميم

- **Header**: خلفية رمادية فاتحة مع أيقونة التقويم
- **Options**: قائمة عمودية مع radio buttons
- **Selected**: خلفية كهرمانية فاتحة للخيار المحدد
- **Hover**: تأثير hover رمادي فاتح
- **Radio**: لون كهرماني مع تأثيرات متحركة

## CSS Classes

- `.duration-radio`: تخصيص radio buttons
- `.custom-scrollbar`: تخصيص شريط التمرير
- Animation keyframes: `radioCheck` للتحقق من الاختيار
