'use client'
import { Link } from "@/navigation";
import { CaretLeftOutlined, CaretRightOutlined } from '@ant-design/icons';
import { Button, Col, Row } from 'antd';

const CustomSubmitReservation = ({ openNext = true, openBack = true, t, loading, back, next, onSubmit, className }) => {
  return (
    <div className={className} >
      <Row gutter={[16, 16]} className=" mt-[20px]  ">
        {openBack && <Col xs={24} md={8}>
          <Link href={back}>
            <Button
              size="large"
              type="default"
              block
              icon={<CaretLeftOutlined />}
              className="  h-[54px] [&_span]:text-[14px] [&_span]:font-medium [&_svg]:rotate-[180deg] "
              iconPosition="start"
            >
              {t("back_to_cars")}
            </Button>
          </Link>
        </Col>}
        {openNext && <Col xs={24} md={openBack ? 16 : 24}>
          <Button
            type="primary"
            size="large"
            block
            icon={<CaretRightOutlined />}
            className="  h-[54px] [&_span]:text-[14px] [&_span]:font-medium [&_svg]:rotate-[180deg] "
            iconPosition="end"
            htmlType="submit"
            loading={loading}
          >
            {t(next)}
          </Button>
        </Col>}
      </Row>
    </div>
  );
}
export default CustomSubmitReservation;
