import Icon from '@/constants/icon';
import img from '@/constants/img';
import { Button } from 'antd';
import { useTranslations } from 'next-intl';
import Image from 'next/image';
import { useSelector } from 'react-redux';
const capitalize = (str) => {
    if (!str) return '';
    return str.charAt(0).toUpperCase() + str.slice(1).toLowerCase();
};
const PromoCodes = ({ promoCode, isCopied, handleCopy, locale }) => {
    const { settings } = useSelector((state) => state.shared);
    const { user } = useSelector((state) => state.profile);

    const t = useTranslations('profile');

    const handleShare = () => {
        const refCode = user?.refCode || '';
        const consumerPoints = settings?.REFERRAL_POINTS_FOR_CONSUMER || '50';
        const name = capitalize(user?.firstName) + ' ' + capitalize(user?.lastName);
  const rewardText = `مرحباً! 🎉
كود ترويجي من صديقك ${name}
الكود: ${refCode}
استخدم هذا الكود وسجّل لتحصل على ${consumerPoints} نقطة 🎁
احجز الآن من:
الموقع: https://www.alghazal.sa/ar/
تطبيق Android: https://play.google.com/store/apps/details?id=com.vigtas.algazal&hl=en
تطبيق iOS: https://www.ios.com/alghazal`;

        if (navigator.share) {
            navigator.share({
                title: 'دعوة صديق',
                text: rewardText,
            })
                .then(() => {
                    // Share successful
                })
                .catch((error) => {
                    // Handle share error silently
                });
        } else {
            navigator.clipboard.writeText(rewardText)
                .then(() => {
                    message.success('✅ تم نسخ رسالة الدعوة إلى الحافظة');
                })
                .catch(() => {
                    message.error('❌ فشل نسخ الرسالة');
                });
        }
    };
    return (
        <div className="w-full">
            <div className="flex items-center gap-5">
                <div className="flex gap-2 flex-col">
                    <section className="pt-3 mb-1">
                        <div className="flex items-center gap-2 [&_svg]:w-5 [&_svg]:h-5 [&_svg]:text-main  [&_svg]:fill-current">
                            <Image width={30} height={30} loading="lazy" src={img.invite} alt="invite a friend" />
                            <h2 className="text-lg font-semibold text-gray-800">{t('send_invite')}</h2>
                        </div>
                    </section>
                    <p className="text-custom">
                        {t('title_invite_dynamic', {
                            ownerPoints: settings?.REFERRAL_POINTS_FOR_OWNER || '',
                            consumerPoints: settings?.REFERRAL_POINTS_FOR_CONSUMER || ''
                        })}
                    </p>
                </div>
            </div>

            <div className="flex items-center justify-between border px-4 py-1 mt-4 rounded-lg">
                <span className="text-sm font-medium text-gray-700">{promoCode}</span>
                <Button
                    onClick={handleShare}
                    className="px-5 bg-gray-800 rounded text-white !bg-main transition"
                >
                    <Icon.ShareIcon className="text-white" />
                </Button>
            </div>
        </div>
    )
}

export default PromoCodes
