"use client";
import img from "@/constants/img";
import { Drawer } from "antd";
import { useLocale, useTranslations } from "next-intl";
import Image from "next/image";
import { useEffect, useState } from "react";
import { useSelector } from 'react-redux';
import MemberInfoCard from "./MemberInfoCard";
import PointsCards from "./PointsCards";
import PointsInfo from "./PointsInfo";
import PromoCodes from "./PromoCodes";
import TierList from "./TierList";

const PointsSidebar = ({ open, onClose }) => {
  const t = useTranslations("points_sidebar");
  const locale = useLocale();
  const [placement, setPlacement] = useState("left");
  const [drawerWidth, setDrawerWidth] = useState(411);
  const { user, loading } = useSelector((state) => state.profile);

  const points = user?.totalPoints;
  const currentPoints = user?.pointsCalculation;
  const [isCopied, setIsCopied] = useState(false);

  const handleCopy = () => {
    navigator.clipboard.writeText(user?.refCode)
      .then(() => {
        setIsCopied(true);
        setTimeout(() => setIsCopied(false), 2000);
      })
      .catch(err => {
        console.error('Failed to copy text: ', err);
        const textArea = document.createElement("textarea");
        textArea.value = user?.refCode;
        document.body.appendChild(textArea);
        textArea.select();
        try {
          document.execCommand('copy');
          setIsCopied(true);
          setTimeout(() => setIsCopied(false), 2000);
        } catch (err) {
          console.error('Fallback copy failed: ', err);
        }
        document.body.removeChild(textArea);
      });
  };
  useEffect(() => {
    const handleResize = () => {
      const width = window.innerWidth;
      const isMobile = width < 768;
      const isTablet = width >= 768 && width <= 1024;
      
      if (isMobile) {
        setPlacement("bottom");
        setDrawerWidth("100%");
      } else if (isTablet) {
        // On iPad, use sidebar with appropriate width
        setPlacement(locale === "ar" ? "right" : "left");
        setDrawerWidth(Math.min(400, width * 0.6)); // 60% of screen width or max 400px
      } else {
        setPlacement(locale === "ar" ? "right" : "left");
        setDrawerWidth(411);
      }
    };

    handleResize(); // Run on mount
    window.addEventListener("resize", handleResize); // Update on resize

    return () => window.removeEventListener("resize", handleResize);
  }, [locale]);
  return (
    <>
      <style dangerouslySetInnerHTML={{
        __html: `
          .points-sidebar .ant-drawer-body { 
          }
          
          .points-sidebar .ant-drawer-body::-webkit-scrollbar {
            width: 6px;
          }
          
          .points-sidebar .ant-drawer-body::-webkit-scrollbar-track {
  background: #f8fafc;
  border-radius: 3px;
          }
          
          .points-sidebar .ant-drawer-body::-webkit-scrollbar-thumb {
  background: #cbd5e1;
  border-radius: 3px;
  transition: background 0.2s ease;
          }
          
          .points-sidebar .ant-drawer-body::-webkit-scrollbar-thumb:hover {
     background: #94a3b8;
          }
        `
      }} />

      <Drawer
        title={<div className="flex justify-between items-center  ">
          <div></div>
          <div className="text-lg font-semibold text-gray-800">{t("point")}</div>
          <div>
            <Image src={img.logoDark} alt="الغزال" priority width={50} height={30} />
          </div>
        </div>
        }
        placement={placement}
        onClose={onClose}
        open={open}
        width={drawerWidth}
        height="100%"
        className="points-sidebar [&_.ant-drawer-body]:p-3  [&_.ant-drawer-body]:bg-[#fbf3e0] "
      >
        <div className="flex flex-col items-center gap-4  bg-white rounded-[8px]      shadow-[0px_8px_24px_0px_#959DA533]  border border-[#E4E4E4] p-4 ">
          {/* Card image */}
          <MemberInfoCard t={t} locale={locale} points={points} />


          <TierList points={points} />

          {/* Points Cards */}
          <PointsCards t={t} currentPoints={user?.totalPoints} acquiredPoints={user?.acquiredPoints} />
          {/* Promo Code */}
          <PromoCodes t={t} promoCode={user?.refCode} isCopied={isCopied} handleCopy={handleCopy} locale={locale} />

          {/* Points Info */}
          <PointsInfo t={t} />
        </div>
      </Drawer>
    </>
  );
};

export default PointsSidebar;
