import img from '@/constants/img';
import { Col, Row } from 'antd';
import { useTranslations } from 'next-intl';
import Image from 'next/image';
import { useSelector } from 'react-redux';
const PointsCards = ({ t }) => {
    const { user, loading } = useSelector((state) => state.profile);
    const tCommon = useTranslations();
    return (
        <Row gutter={[16, 16]} className="w-full mt-3">


            {/* Acquired Points Card */}
            <Col xs={24} sm={12}>
                <div className="bg-[#F8F6F0] rounded-lg p-4 border border-gray-200 flex items-  gap-2">
                    <div className="flex items-center !h-full">
                        <div className="  w-[21px] h-[21px]  mt-2 ">
                            <Image src={img.pointCard} alt="Point Card" width={1000} height={1000} className="w-full h-full" quality={100} priority loading="eager" />
                        </div>
                    </div>
                    <div  >
                        <p className="text-2xl font-bold text-gray-800 mb-1">
                            {user?.totalPoints?.toLocaleString() || '0'}
                        </p>
                        <p className="text-sm text-gray-600"> {tCommon('points_earned')}</p>
                    </div>
                </div>
            </Col>

            {/* Current Points Card */}
            <Col xs={24} sm={12}>
                <div className="bg-[#F8F6F0] rounded-lg p-4 border border-gray-200 flex items-  gap-2">
                    <div className="flex items-center !h-full">
                        <div className="  w-[21px] h-[21px]  mt-2 ">
                            <Image src={img.pointCard2} alt="Point Card" width={1000} height={1000} className="w-full h-full" quality={100} priority loading="eager" />
                        </div>
                    </div>
                    <div  >
                        <p className="text-2xl font-bold text-gray-800 mb-1">
                            {user?.pointsCalculation?.toLocaleString() || '0'}
                        </p>
                        <p className="text-sm text-gray-600"> {tCommon('points_current')}</p>
                    </div>
                </div>
            </Col>
        </Row>
    );
};

export default PointsCards;
