import img from '@/constants/img';
import Image from 'next/image';
import { useSelector } from 'react-redux';

const MemberInfoCard = ({ t, locale, points }) => {
    const user = useSelector((state) => state.profile.user);
    const { membership } = useSelector((state) => state.shared);
    return (
        <div className="relative w-full h-[177px] rounded-lg">
            <Image
                src={membership ? membership.icon : img.all_card}
                width={321}
                height={177}
                alt="Points Card"
                className="rounded-lg relative w-full"
            /> 
        </div>
    )
}

export default MemberInfoCard
