"use client";
import img from "@/constants/img";
import { CheckOutlined } from '@ant-design/icons';
import { Drawer } from 'antd';
import { useLocale, useTranslations } from "next-intl";
import Image from 'next/image';

const MobileLanguageDrawer = ({ visible, onClose, onLanguageSelect }) => {
  const t = useTranslations();
  const locale = useLocale();

  const languages = [
    { code: 'ar', name: 'العربية', flag: img.LangAr },
    { code: 'en', name: 'English', flag: img.LangEn }
  ];

  const handleLanguageSelect = (langCode) => {
    onLanguageSelect(langCode);
    onClose();
  };

  return (
    <Drawer
      title={<strong className="flex justify-center w-full">{t("lang_title")}</strong>}
      placement="bottom"
      closable
      onClose={onClose}
      open={visible}
      height="auto"
      className="points-sidebar [&_.ant-drawer-body]:p-3  [&_.ant-drawer-body]:bg-[#fbf3e0] "

    >
      <div className="bg-white rounded-sm shadow-sm divide-y border w-[90%] max-w-sm mx-auto">
        {languages.map((lang) => (
          <div
            key={lang.code}
            className="flex justify-between items-center px-4 py-3 cursor-pointer hover:bg-gray-50"
            onClick={() => handleLanguageSelect(lang.code)}
          >
            <div className="flex items-center gap-2">
              <Image src={lang.flag} alt={`${lang.name} flag`} width={24} height={16} />
              <span className="text-sm text-gray-800">{lang.name}</span>
            </div>
            {locale === lang.code && (
              <CheckOutlined className="text-green-600 text-base" />
            )}
          </div>
        ))}
      </div>
    </Drawer>
  );
};

export default MobileLanguageDrawer;
