"use client";
import { Link, useRouter } from "@/navigation";
import { handleLogout as logoutUser } from '@/utils/authUtils';
import { EditOutlined, GlobalOutlined, LogoutOutlined, UserOutlined } from "@ant-design/icons";
import CarIconNew from "@components/svg/CarIconNew";
import LimIconNew from "@components/svg/LimIconNew";
import { Dropdown, message } from "antd";
import { useTranslations } from "next-intl";
import Image from "next/image";
import { useState } from "react";
import { useSelector } from "react-redux";
import Avater from "../svg/Avater";

const UserDropdown = ({ onLanguageClick }) => {
  const t = useTranslations();
  const router = useRouter();
  const { user } = useSelector((state) => state.profile);
  const [open, setOpen] = useState(false);

  const capitalize = (str) => {
    if (!str) return '';
    return str.charAt(0).toUpperCase() + str.slice(1).toLowerCase();
  };

  const handleLogout = () => {
    const success = logoutUser();
    if (success) {
      message.success(t("logout_success"));
      router.push("/login");
    } else {
      message.error(t("logout_error") || "Logout failed");
    }
  };

  const items = [
    {
      key: "profile",
      label: (
        <div onClick={() => router.push("/profile")} className="flex items-center gap-3 py-2 hover:bg-gray-200 px-3 w-full rounded-md transition-all">
          <UserOutlined className="text-lg text-gray-600" />
          <span className="text-sm text-gray-800">{t("menu.profile")}</span>
        </div>
      ),
    },
    {
      key: "current-car",
      label: (
        <div onClick={() => router.push("/current-reservations")} className="flex items-center gap-3 py-2 hover:bg-gray-200 px-3 w-full rounded-md transition-all">
          <div className="w-5 h-5 flex items-center justify-center">
            <CarIconNew className="text-gray-600" />
          </div>
          <span className="text-sm text-gray-800">{t("menu.current_car")}</span> 
        </div>
      ),
    },
    {
      key: "current-limo",
      label: (
        <div onClick={() => router.push("/current-limousine-reservations")} className="flex items-center gap-3 py-2 hover:bg-gray-200 px-3 w-full rounded-md transition-all">
          <div className="w-5 h-5 flex items-center justify-center">
            <LimIconNew className="text-gray-600" />
          </div>
          <span className="text-sm text-gray-800">{t("menu.current_limo")}</span>
        </div>
      ),
    },
    {
      key: "lang",
      label: (
        <div onClick={onLanguageClick} className="flex items-center gap-3 py-2 hover:bg-gray-200 px-3 w-full rounded-md transition-all">
          <GlobalOutlined className="text-lg text-gray-600" />
          <span className="text-sm text-gray-800">{t("menu.language")}</span>
        </div>
      ),
    },
    {
      key: "update-password",
      label: (
        <div onClick={() => {
          router.push("/profile/update-password");
          document.body.click();
        }} className="flex items-center gap-3 py-2 hover:bg-gray-200 px-3 w-full rounded-md transition-all">
          <EditOutlined className="text-lg text-gray-600" />
          {t("menu.change_password")}
        </div>
      ),
    },
    {
      key: "logout",
      label: (
        <div onClick={handleLogout} className="flex items-center gap-3 py-2 hover:bg-gray-200 px-3 w-full rounded-md transition-all">
          <LogoutOutlined className="text-lg text-gray-600" />
          <span className="text-sm text-gray-800">{t("menu.logout")}</span>
        </div>
      ),
    },
    {
      type: "divider",
    },
    {
      key: "account",
      label: (
        <Link href="/profile" className="py-3 px-4 bg-gray-100 hover:bg-gray-200 flex items-center w-[250px] gap-2 rounded-xl shadow-sm cursor-pointer">
          {user?.image ? (
            <Image src={user?.image} alt="user" width={40} height={40} className="rounded-[50%] !object-cover !h-[40px] !w-[40px]" />
          ) : (
            <Avater />
          )} 
          <div className="flex flex-col">
            <span className="font-semibold text-sm text-bold">{capitalize(user?.firstName) + ' ' + capitalize(user?.lastName)}</span>
            <span className="text-xs text-gray-500">{user?.email}</span>
          </div>
        </Link>
      ),
    },
  ];

  return (
    <Dropdown
      menu={{ items }}
      placement="bottomRight"
      trigger={["click"]}
      arrow
    >
      <div className="cursor-pointer flex items-center">
        {user?.image ? (
          <Image src={user?.image} alt="user" width={40} height={40} className="rounded-[50%] object-cover h-[40px] w-[40px]" />
        ) : (
          <Avater />
        )}
      </div>
    </Dropdown>
  );
};

export default UserDropdown;
