"use client";
import { useTranslations } from "next-intl";
import { useSelector } from "react-redux";
import StarPoints from "../svg/StarPoints";

const PointsDisplay = ({ onPointsClick, isMobile = false }) => {
  const t = useTranslations();
  const { user } = useSelector((state) => state.profile);

  return (
    <div
      className={`flex items-center gap-1 cursor-pointer ${isMobile ? "max-sm:px-3 sm:!hidden" : ""}`}
      onClick={onPointsClick}
    >
      <div className="flex flex-col items-end">
        <span className={`text-sm ${isMobile ? "max-sm:text-[12px]" : ""}`}>
          {user?.pointsCalculation}
        </span>
        <span className={`text-xs font-light ${isMobile ? "max-sm:text-[8px]" : ""}`}>
          {t('points')}
        </span>
      </div>
      <StarPoints />
    </div>
  );
};

export default PointsDisplay;
