"use client";
import { Link, usePathname } from "@/navigation";
import { useTranslations } from "next-intl";

const NavLinks = ({ isMenuOpen }) => {
  const t = useTranslations();
  const pathname = usePathname();

  return (
    <nav className={`navbar-links ${isMenuOpen ? "show-links" : "d-none"}`}>
      <Link className={`${pathname == "/" ? "active" : ""}`} href="/">
        {t("nav_home")}
      </Link>
      <Link href="/cars" className={`${(pathname == "/cars" || pathname == "/limo") ? "active" : ""}`}>
        {t("nav_fleet")}
      </Link>
      <Link href="/branches" className={`${pathname == "/branches" ? "active" : ""}`}>
        {t("nav_branches")}
      </Link>
      <Link href="/about" className={`${pathname == "/about" ? "active" : ""}`}>
        {t("nav_about")}
      </Link>
      <Link href="/contactus" className={`${pathname == "/contactus" ? "active" : ""}`}>
        {t("nav_contact")}
      </Link>
      <Link href="/membership" className={`${pathname == "/membership" ? "active" : ""}`}>
        {t("nav_membership")}
      </Link>
    </nav>
  );
};

export default NavLinks;
