"use client";
import img from "@/constants/img";
import { CheckCircleOutlined } from "@ant-design/icons";
import { Modal } from "antd";
import { useLocale, useTranslations } from "next-intl";
import Image from "next/image";

const LanguageModal = ({ isVisible, onClose, onLanguageChange }) => {
  const t = useTranslations();
  const locale = useLocale();

  return (
    <Modal
      title={
        <span className="text-2xl font-bold text-center w-full block pt-[10px]">
          {t("lang_title")}
        </span>
      }
      open={isVisible}
      onCancel={onClose}
      footer={null}
      centered
      className="rounded-xl"
    >
      <div className="flex justify-between gap-4 px-9 pb-[20px] pt-5">
        {/* Arabic Card */}
        <div
          onClick={() => onLanguageChange("ar")}
          className={`relative flex flex-col items-center justify-center gap-2 w-1/2 min-h-[120px] border rounded-xl py-4 shadow-md cursor-pointer transition-all duration-300
            ${locale === "ar" ? "bg-[#162a2b46]" : "hover:shadow-lg hover:border-[#E5B63A]"}`}
        >
          {locale === "ar" && (
            <div className="absolute top-2 left-2 w-5 h-5 text-white text-xs flex items-center justify-center rounded-full shadow-sm">
              <CheckCircleOutlined
                style={{ color: "#162A2B", fontSize: "18px" }}
              />
            </div>
          )}

          <Image
            width={20}
            height={14}
            src={img.LangAr}
            alt="Arabic Flag"
            className="w-10 h-auto"
            priority
          />
          <span className="text-base font-semibold text-[#3A3A3A]">
            العربية
          </span>
        </div>

        {/* English Card */}
        <div
          onClick={() => onLanguageChange("en")}
          className={`relative flex flex-col items-center justify-center gap-2 w-1/2 min-h-[120px] border rounded-xl py-4 shadow-md cursor-pointer transition-all duration-300
            ${locale === "en" ? "bg-[#162a2b46]" : "hover:shadow-lg hover:border-[#E5B63A]"}`}
        >
          {locale === "en" && (
            <div className="absolute top-2 left-2 w-5 h-5 bg-main text-white text-xs flex items-center justify-center rounded-full shadow-sm">
              ✓
            </div>
          )}
          <Image
            width={20}
            height={14}
            src={img.LangEn}
            alt="English Flag"
            className="w-10 h-auto"
            priority
          />
          <span className="text-base font-semibold text-[#3A3A3A]">
            English
          </span>
        </div>
      </div>
    </Modal>
  );
};

export default LanguageModal;
