'use client'
import Icon from '@/constants/icon';
import img from '@/constants/img';
import { Link } from '@/navigation';
import { FacebookOutlined, InstagramOutlined, LinkedinOutlined, XOutlined } from '@ant-design/icons';
import { Col, Row } from 'antd';
import { useLocale, useTranslations } from 'next-intl';
import Image from 'next/image';
import { useSelector } from 'react-redux';
import './footer.css';
import Subscribed from './Subscribed';

const Footer = () => {
  const t = useTranslations();
  const locale = useLocale();
  const { contact } = useSelector((state) => state.shared);


  return (
    <div className="app__footer pt-10 overflow-hidden min-h-[500px] " dir={locale === "en" ? 'ltr' : 'rtl'}>
      <div className="footer-container">
        <Row gutter={[32, 32]}>
          {/* LOGO & SOCIAL */}
          <Col xl={6} lg={6} md={12} sm={24} xs={24} className='max-md:order-1 ' >
            <div className="mt-4 max-sm:mb-4 flex flex-col justify-center items-center gap-[0px]">
              <Image className="mb-4 max-sm:p-4 " src={img.logo} priority width={200} height={60} alt="Logo" />
              <div className="social flex items-center gap-4 text-secondary text-xl ">

                <a href={contact?.instagram} target="_blank" rel="noopener noreferrer">
                  <InstagramOutlined />
                </a>
                <a href={contact?.facebook} target="_blank" rel="noopener noreferrer">
                  <FacebookOutlined />
                </a>
                <a href={contact?.twitter} target="_blank" rel="noopener noreferrer">
                  <XOutlined />
                </a>
                <a href={contact?.linkedin} target="_blank" rel="noopener noreferrer">
                  <LinkedinOutlined />
                </a>
                <a href={contact?.tiktok} target="_blank" rel="noopener noreferrer" aria-label={locale === 'ar' ? 'تابعنا على تيك توك' : 'Follow us on TikTok'}>
                  <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor" aria-hidden="true">
                    <path d="M19.59 6.69a4.83 4.83 0 0 1-3.77-4.25V2h-3.45v13.67a2.89 2.89 0 0 1-5.2 1.74 2.89 2.89 0 0 1 2.31-4.64 2.93 2.93 0 0 1 .88.13V9.4a6.84 6.84 0 0 0-1-.05A6.33 6.33 0 0 0 5 20.1a6.34 6.34 0 0 0 10.86-4.43v-7a8.16 8.16 0 0 0 4.77 1.52v-3.4a4.85 4.85 0 0 1-1-.1z" />
                  </svg>
                </a>
                <a href={contact?.snapchat} target="_blank" rel="noopener noreferrer" aria-label={locale === 'ar' ? 'تابعنا على سناب شات' : 'Follow us on Snapchat'}>
                  <svg width="20" height="20" viewBox="0 -6.5 160 160" fill="currentColor" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                    <path d="M153.473 106.27C152.816 105.8 152.164 105.326 151.517 104.851C150.899 104.4 150.278 103.95 149.658 103.501C138.187 95.2542 132.604 83.4172 131.577 65.154L134.828 62.6896C138.087 60.2211 141.304 57.7833 144.503 55.3253L145.078 54.8856C146.409 53.9354 147.645 52.8584 148.77 51.6696C150.991 49.1755 151.067 45.8499 148.946 43.768C146.977 41.8383 144.367 41.6058 141.778 43.1318C140.896 43.6897 140.072 44.3342 139.318 45.0556C139.037 45.3063 138.758 45.557 138.471 45.7959L129.909 52.9291C129.857 52.6456 129.807 52.3692 129.757 52.0975C129.429 50.2807 129.167 48.846 128.759 47.3903C128.279 45.6667 127.84 43.8768 127.414 42.1454L127.389 42.0444C126.278 37.5157 125.129 32.8294 123.115 28.5651C116.775 15.1345 105.985 5.97408 91.9123 2.07477C74.4668 -2.75981 54.8243 5.08068 44.1424 21.1406C37.6447 30.9135 35.5687 41.8009 34.489 50.1935C34.2672 51.9164 34.0401 53.6393 33.767 55.7153L33.6653 56.4845L32.3034 55.1718C29.974 52.9265 27.9624 50.9876 25.912 49.0619L25.5838 48.752C24.5198 47.6693 23.3347 46.7128 22.052 45.9011C20.8209 45.1127 19.3389 44.8147 17.8987 45.0659C16.4585 45.317 15.1648 46.0991 14.2731 47.2576C13.4248 48.2811 12.9772 49.578 13.0134 50.9069C13.0496 52.2358 13.5672 53.506 14.47 54.4818C15.7131 55.884 17.0828 57.1688 18.5616 58.3196C22.0081 61.1707 25.5497 64.0554 28.6745 66.5998L31.968 69.2849C31.8367 80.5923 28.9141 91.6254 23.7316 100.386C19.2941 107.889 13.3306 111.993 5.50051 112.931C4.45759 113.055 1.48569 112.62 0.769625 115.569C-0.438694 120.547 1.25858 122.219 6.41411 124.723C10.4375 126.676 14.6663 128.315 18.7881 129.913C21.0675 130.797 23.4238 131.711 25.7059 132.665C27.184 133.282 28.6712 133.991 29.5382 134.988C33.9154 140.009 37.3801 140.956 43.2688 138.739C44.7127 138.194 46.1009 137.516 47.466 136.848L48.2773 136.454C52.5672 134.376 56.3227 134.738 60.0973 137.594C63.5848 140.237 67.3823 142.444 71.4063 144.164C74.6899 145.612 78.2316 146.386 81.8204 146.441H81.825C86.8506 146.403 91.7167 144.671 95.637 141.525C96.3471 140.981 97.0685 140.448 97.8364 139.88C98.3614 139.493 98.8839 139.104 99.405 138.714C101.751 136.882 104.46 135.57 107.353 134.866C110.245 134.163 113.254 134.083 116.18 134.633C116.77 134.73 117.37 134.839 117.968 134.947L118.085 134.301L118.053 134.962C120.378 135.477 122.756 135.716 125.137 135.674C129.054 135.458 131.828 134.58 133.382 133.066C135.444 131.058 136.388 126.751 139.044 126.109C145.299 124.599 152.939 126.036 156.568 119.331C160.398 112.255 160.109 111.035 153.473 106.27ZM148.597 115.162C143.861 120.194 136.213 114.787 131.717 119.283C130.264 120.736 131.555 125.721 127.69 126.445C126.388 126.688 121.839 126.758 120.697 126.299C111.421 122.566 102.516 124.024 93.4842 130.756C92.6395 131.384 91.9234 131.966 91.2946 132.532C85.6055 137.664 79.3946 138.299 72.3074 134.472L71.5008 134.039C69.2279 132.888 67.0416 131.575 64.9581 130.109C61.4749 127.519 57.8362 126.206 54.1411 126.206C50.7909 126.287 47.514 127.203 44.6083 128.873C39.7895 131.478 38.8326 130.558 36.3346 128.61C32.6348 125.727 31.3582 124.409 28.5898 123.731C25.2004 122.903 21.7501 121.921 18.3345 120.813C16.9695 120.339 15.6327 119.787 14.3309 119.16L13.9593 118.99C23.893 114.921 31.0045 107.072 35.6875 95.0114C38.832 86.9102 40.0757 78.4481 41.1705 69.7673L41.6076 66.2828C42.6951 57.5922 43.8195 48.6058 45.4918 39.8982C46.9003 32.5616 50.7051 25.7783 56.7992 19.7347C67.4414 9.18144 87.2116 4.82212 102.888 17.5295C112.156 25.0406 117.557 35.1672 119.401 48.4876C120.496 56.4057 121.562 64.4669 122.593 72.2627L123.154 76.5027C125.169 91.7205 132.779 103.966 145.773 112.898C146.556 113.437 147.305 114.069 148.171 114.801L148.597 115.162Z" fill="currentColor" />
                  </svg>
                </a>
              </div>
            </div>

          </Col>


          {/* COMPANY + RENT */}
          <Col xl={12} lg={12} md={24} sm={24} xs={24} className='max-md:order-2  ' >
            <Row gutter={[16, 16]}   >
              <Col xl={12} lg={12} md={12} sm={12} xs={12} className='mt-4  order-1 sm:order-2 md:order-2 lg:order-3   '>
                <div className='footer_Links'>
                  <h3>{t('company')}</h3>
                  <div className="footer_ui">
                    <ul>
                      <li><Link href={`/`} className="nav-link">{t('nav_home')}</Link></li>
                      <li><Link href={`/cars`} className="nav-link">{t('nav_fleet')}</Link></li>
                      <li><Link href={`/branches`} className="nav-link">{t('nav_branches')}</Link></li>

                      <li><Link href={`/blogs`} className="nav-link">{t('nav_blog')}</Link></li>
                    </ul>
                  </div>
                </div>
              </Col>
              <Col xl={12} lg={12} md={12} sm={12} xs={12} className='mt-4  order-1 sm:order-2 md:order-2 lg:order-3   '>
                <div className='footer_Links'>
                  <h3>{t('rent')}</h3>
                  <div className="footer_ui">
                    <ul>
                      <li><Link href={`/?tab=rental`} className="nav-link">{t('rent2')}</Link></li>
                      <li><Link href={`/?tab=companies`} className="nav-link">{t('companies')}</Link></li>
                      <li><Link href={`/?tab=limousine`} className="nav-link">{t('limousine.title')}</Link></li>
                    </ul>
                  </div>

                </div>
              </Col>
            </Row>
          </Col>

          {/* SUPPORT */}
          <Col xl={6} lg={6} md={12} sm={24} className='mt-4 footer_lg max-md:order-3'>
            <div className='footer_Links'>
              <h3>{t('support')}</h3>
              <div className="footer_ui">
                <ul>
                  <li ><a dir='ltr' href={`tel:${contact?.phone}`} target='_blank' rel='noreferrer'>{contact?.phone}</a></li>
                  <li>
                    <Link href={`/branches`} >
                      {t('sar_address')}
                    </Link>
                  </li>
                  <li><a href={`mailto:${contact?.email}`} target='_blank' rel='noreferrer' >  {contact?.email} </a></li>
                  <li className='payment_icons flex flex-row gap-3'>
                    <Icon.Visa />
                    <Icon.Mastercard />
                    <Icon.MadaCard />
                  </li>
                </ul>
              </div>
            </div>
          </Col>
        </Row>

        <Subscribed />
        <hr className='hr__footer' />
        <div className="footer__buttom w-full mt-4   pb-4 flex justify-center items-center">
          <Row className='w-full footer_sm'>
            <Col xl={12} lg={12} md={24} sm={24}>
              <p className='footer_sm'>{t('footer', { year: new Date().getFullYear() })}</p>
            </Col>
            <Col xl={12} lg={12} md={24} sm={24}>
              <div className="links">
                <ul className='flex flex-row  w-full '>
                  <li> <Link href={`/terms-of-use`} className="nav-link">{t('terms')}</Link>  </li>
                  <li> <Link href={`/privacy-policy`} className="nav-link">{t('privacy')}</Link>  </li>
                  <li> <Link href={`/contactus`} className="nav-link"> {t('nav_contact')}   </Link> </li>
                  <li> <Link href={`/about`} className="nav-link"> {t('nav_about')} </Link> </li>
                </ul>
              </div>
            </Col>
          </Row>

        </div>
      </div>
    </div>
  );
};

export default Footer;
