'use client';

import img from '@/constants/img';
import { Link } from '@/navigation';
import { formatNumber } from '@/utils/format';
import { Button, Card } from 'antd';
import { useLocale, useTranslations } from 'next-intl';
import Image from 'next/image';
import { useSearchParams } from 'next/navigation';
import { useSelector } from 'react-redux';
import Riyal from '../svg/Riyal';
import './card.css';
 
const Cards = ({ item, path, limo = true }) => {
    // get duration from url
    const searchParams = useSearchParams();
    const durationUrl = searchParams.get('duration');
        
    const locale = useLocale(); 
    const t = useTranslations();
    const { duration } = useSelector((state) => state.rental);

    function formatPrice(price) {
        const num = parseFloat(price);
        return isNaN(num) ? 0 : (num % 1 === 0
            ? num.toLocaleString('en-US')
            : num.toLocaleString('en-US', { minimumFractionDigits: 2 }));
    }

    const datingType = item.datingType;

    const title = locale == "en" ? item.modelEnglishName : item.modelArabicName;
    const brand = locale == "en" ? item.brandName : item.brandArabicName;
    const category = locale == "en" ? item.categoryEnglishName : item.categoryArabicName;
    const year = item.carYear || item.year;
    const carImage = (item.image || item.defaultImage) || img.noImage;

    let hasOffer, originalPrice, offerPrice;

    hasOffer = datingType == "0" ? item.offerDailyPrice > 0 : datingType == "2" ? item.offerWeeklyPrice > 0 : datingType == "3" ? item.offerYearlyPrice > 0 : item.offerFinalPrice > 0;
    // if (pathname === '/') {
    //     originalPrice = datingType == "0" ? item.dailyPrice : datingType == "2" ? item.weeklyPrice : datingType == "3" ? item.monthlyPrice : (item.finalPrice || item.price);
    //     offerPrice = datingType == "0" ? item.offerDailyPrice : datingType == "2" ? item.offerWeeklyPrice : datingType == "3" ? item.offerYearlyPrice : item.offerFinalPrice;
    // }
    // else {
    //     hasOffer = datingType == "1" ? item.offerDailyPrice > 0 : datingType == "2" ? item.offerWeeklyPrice > 0 : datingType == "3" ? item.offerYearlyPrice > 0 : item.offerFinalPrice > 0;
    //     originalPrice = datingType == "1" ? item.dailyPrice : datingType == "2" ? item.weeklyPrice : datingType == "3" ? item.monthlyPrice : (item.finalPrice || item.price);
    //     offerPrice = datingType == "1" ? item.offerDailyPrice : datingType == "2" ? item.offerWeeklyPrice : datingType == "3" ? item.offerYearlyPrice : item.offerFinalPrice;
    // }

    // تحديد السعر حسب المدة المختارة من الفلتر
    const getPriceByDuration = () => {
        // التحقق من وجود عرض بناءً على finalPriceBeforeDiscount
        const hasDiscount = item.finalPriceBeforeDiscount && item.finalPrice && item.finalPriceBeforeDiscount > item.finalPrice;

        switch (duration) {
            case 'daily':
                return {
                    hasOffer: hasDiscount || item.offerDailyPrice > 0,
                    originalPrice: hasDiscount ? item.finalPriceBeforeDiscount : (item.finalPrice || item.price || item.dailyPrice),
                    offerPrice: hasDiscount ? item.finalPrice : (item.offerDailyPrice || item.finalPrice || item.price || item.dailyPrice),
                    priceLabel: t('daily_price')
                };
            case 'weekly':
                return {
                    hasOffer: hasDiscount || item.offerWeeklyPrice > 0,
                    originalPrice: hasDiscount ? item.finalPriceBeforeDiscount : (item.finalPrice || item.price),
                    offerPrice: hasDiscount ? item.finalPrice : (item.finalPrice || item.price),
                    priceLabel: t('weekly_price')
                };
            case 'monthly':
                return {
                    hasOffer: hasDiscount || item.offerYearlyPrice > 0,
                    originalPrice: hasDiscount ? item.finalPriceBeforeDiscount : (item.finalPrice || item.price),
                    offerPrice: hasDiscount ? item.finalPrice : (item.finalPrice || item.price),
                    priceLabel: t('monthly_price')
                };
            default:
                return {
                    hasOffer: hasDiscount || item.offerDailyPrice > 0,
                    originalPrice: hasDiscount ? item.finalPriceBeforeDiscount : item.dailyPrice,
                    offerPrice: hasDiscount ? item.finalPrice : item.offerDailyPrice,
                    priceLabel: t('daily_price')
                };
        }
    };

    const priceInfo = getPriceByDuration();

    const type = locale == 'ar' ? item.typeArabicName : (item.typeEnglishName || item.typeName);
    const modelName = limo == "true" ? (locale == 'en' ? item.modelName : item.modelArabicName) : (locale == 'en' ? item.modelEnglishName : item.modelArabicName) || item.modelName ;
    return (
        <Card
            hoverable
            className=" w-full bg-mian relative app__cars_slider_container overflow-hidden px-3"
            cover={
                <div className="w-full h-[200px] overflow-hidden relative">
                    <Image
                        src={carImage}
                        alt={`${brand} ${title} ${year}`}
                        fill
                        loading="lazy"
                        quality={75}
                        sizes="(max-width: 640px) 100vw, (max-width: 1024px) 50vw, 25vw"
                        className="object-contain"
                    />
                </div>
            }
        >
            <div className="slider_card font-cairo" dir={locale === "en" ? 'ltr' : 'rtl'}>
                <ul>
                    <li className="sub_brand_title">
                        <strong>{brand} </strong>
                    </li>
                    <li className='my-[3px] mt-4'><span  >     {year}  {'  '} ( {modelName} )</span></li>
                    <li className="hr"><hr /></li>
                    {
                        type && (
                            <>
                                <li className='my-[3px]'><span className='bold'>{type}</span></li>
                                <li className="hr"><hr /></li>
                            </>
                        )
                    }
                   

                    {category && (
                        <>
                            <li><span>{category}</span></li>
                            <li className="hr"><hr /></li>
                        </>
                    )}

                    {limo == true && (
                        <>
                            <li className='km_offers'>
                                <p>{t('km_free' , { km: item.maxKm })}  </p>
                            </li>
                            <li className="hr"><hr /></li>
                        </>
                    )}
                    <li className='flex justify-between mt-3'>
                        <div className='flex items-center flex-col'>
                            <div className='flex items-center justify-between w-full gap-2 flex-row '>
                                {priceInfo.hasOffer ? (
                                    <>
                                        <span className='app__discount flex flex-row gap-2 '>
                                            {formatNumber(priceInfo.originalPrice)}
                                        </span>
                                        <span className='flex flex-row gap-2'>
                                            {formatNumber(priceInfo.offerPrice)} <Riyal color="#fff" />
                                        </span>
                                    </>
                                ) : (
                                    <span className='flex flex-row gap-2'>
                                        {formatNumber(priceInfo.originalPrice)} <Riyal color="#fff" className="mt-5" />
                                    </span>
                                )}
                            </div>
                            {item.rentalHours ? (
                                <span className='oneDay'>
                                    {t('hourly_price_text', { hours: item.rentalHours })}
                                </span>
                            ) : item.rentalDays ? (
                                <span className='oneDay'>
                                    {t('daily_price_text', { days: item.rentalDays })}
                                </span>
                            ) : (
                                <span className='oneDay'>
                                    {
                                        item.numOfDays == 1 ? t('tax') : t('daily_price_text', { days: item.numOfDays })
                                    }
                                </span>)}
                        </div>
                        <div className="flex align-end btn_cart_main">
                            {
                                limo == true ?
                                    <Link href={`/booking/${item.carId}?car-name=${brand}_${title}`} aria-label={`${t('book_now')} - ${brand} ${title} ${year}`}>
                                        <Button type="primary">{t('book_now')}</Button>
                                    </Link> :
                                    <Link href={`/limo/${item.id}?car-name=${brand}_${title}&PRICE=${item.price}&rentalHours=${item.rentalHours}&rentalDays=${item.rentalDays}`} aria-label={`${t('book_now')} - ${brand} ${title} ${year}`}>
                                        <Button type="primary">{t('book_now')}</Button>
                                    </Link>
                            }
                        </div>
                    </li>
                </ul>
            </div>

            {
                priceInfo.hasOffer && priceInfo.originalPrice > 0 && (
                    <div
                        className="price absolute flex flex-row gap-2 items-end justify-end"
                        dir={locale === 'en' ? 'ltr' : 'rtl'}
                    >
                        <span className="text-red-500 font-semibold">
                            {Math.round(((priceInfo.originalPrice - priceInfo.offerPrice) / priceInfo.originalPrice) * 100)}% {t('off')}
                        </span>
                    </div>
                )
            }

        </Card >
    );
};


export default Cards
