import { useTranslations } from 'next-intl';
import Image from 'next/image';

const CarNotFound = () => {
  const t = useTranslations('filter');

  return (
    <div className="w-full flex flex-col items-center justify-center py-5 px-4">
      {/* Car Not Found Image */}
      <div className="mb-6">
        <Image
          src="/assets/Images/carNotfound.png"
          alt="No cars available"
          width={120}
          height={120}
          className="w-24 h-24 object-contain"
        />
      </div>

      {/* Text Content */}
      <div className="text-center space-y-2">
        <h3 className="text-xl font-semibold text-gray-700">
          {t('noCarsAvailable')}
        </h3>
        <p className="text-gray-500 text-base">
          {t('noCarsDescription')}
        </p>
      </div>
    </div>
  );
};

export default CarNotFound; 