'use client';

import img from '@/constants/img';
import { Modal } from 'antd';
import { useTranslations } from 'next-intl';
import Image from 'next/image';
import { useEffect, useState } from 'react';
import { useSelector } from 'react-redux';

const AppInstallModal = () => {
  const t = useTranslations();
  const [isVisible, setIsVisible] = useState(false);
  const [deviceType, setDeviceType] = useState(null);
  const [isMounted, setIsMounted] = useState(false);
  const { contact } = useSelector((state) => state.shared);

  useEffect(() => {
    // Set mounted flag to true on client side
    setIsMounted(true);
    
    // Detect device type
    const userAgent = navigator.userAgent || navigator.vendor || window.opera;

    let device = null;
    if (/iPad|iPhone|iPod/.test(userAgent) && !window.MSStream) {
      device = 'ios';
    } else if (/android/i.test(userAgent)) {
      device = 'android';
    }

    // Check if it's a mobile device
    const isMobile = /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(userAgent);

    // Show modal after a short delay (better UX)
    if (isMobile && device) {
      setDeviceType(device);
      setTimeout(() => {
        setIsVisible(true);
      }, 1000); // Show after 1 second
    }
  }, []);

  const handleClose = () => {
    setIsVisible(false);
  };


  const handleInstallClick = () => {
    if (deviceType === 'ios') {
      // Replace with your actual App Store link
      window.open(contact?.iosLink, '_blank');
    } else if (deviceType === 'android') {
      // Replace with your actual Google Play link
      window.open(contact?.androidLink, '_blank');
    }
    handleClose();
  };

  // Don't render anything until client-side hydration is complete
  if (!isMounted) {
    return null;
  }

  return (
    <Modal
      open={isVisible}
      onCancel={handleClose}
      footer={null}
      centered
      width={340}
      className="app-install-modal"
      closeIcon={<span className="text-gray-500 text-xl">×</span>}
    >
      <div className="text-center py-4">
        {/* App Logo */}
        <div className="flex justify-center mb-4">
          <Image
            src={img.logo2}
            alt="Alghazal App"
            width={80}
            height={80}
            className="  "
          />
        </div>

        {/* Title */}
        <h2 className="text-2xl font-bold text-[#162A2B] mb-2">
          {t('app_modal.title') || 'تطبيق الغزال'}
        </h2>

        {/* Description */}
        <p className="text-gray-600 mb-6 px-2">
          {t('app_modal.description') || 'احصل على تجربة أفضل وأسرع مع تطبيق الغزال. احجز سيارتك بسهولة من هاتفك!'}
        </p>

        {/* Download Buttons */}
        <div className="space-y-3">
          {deviceType === 'ios' && (
            <button
              onClick={handleInstallClick}
              className="w-full bg-black text-white py-3 rounded-xl flex items-center justify-center gap-3 hover:bg-gray-800 transition-colors"
            >
              <Image
                src={img.appstore}
                alt="App Store"
                width={60}
                height={60}
              />
              <span className="font-semibold">
                {t('app_modal.download_ios') || 'تحميل من App Store'}
              </span>
            </button>
          )}

          {deviceType === 'android' && (
            <button
              onClick={handleInstallClick}
              className="w-full bg-[#162A2B] text-white py-3 rounded-xl flex items-center justify-center gap-3 hover:bg-[#1a3a3b] transition-colors"
            >
              <Image
                src={img.googleplay}
                alt="Google Play"
                width={50}
                height={50}
              />
              <span className="font-semibold">
                {t('app_modal.download_android') || 'تحميل من Google Play'}
              </span>
            </button>
          )}

          {/* Continue in Browser */}
          <button
            onClick={handleClose}
            className="w-full text-gray-600 py-2 text-sm hover:text-gray-800 transition-colors"
          >
            {t('app_modal.continue_browser') || 'متابعة في المتصفح'}
          </button>
        </div>

        {/* Features */}
        <div className="mt-6 pt-6 border-t border-gray-200">
          <div className="grid grid-cols-3 gap-4 text-center">
            <div>
              <div className="text-2xl mb-1">⚡</div>
              <p className="text-xs text-gray-600">
                {t('app_modal.feature_fast') || 'أسرع'}
              </p>
            </div>
            <div>
              <div className="text-2xl mb-1">🔔</div>
              <p className="text-xs text-gray-600">
                {t('app_modal.feature_notifications') || 'إشعارات'}
              </p>
            </div>
            <div>
              <div className="text-2xl mb-1">📱</div>
              <p className="text-xs text-gray-600">
                {t('app_modal.feature_easy') || 'سهل'}
              </p>
            </div>
          </div>
        </div>
      </div>
    </Modal>
  );
};

export default AppInstallModal;

