// components/AdvancedRentalPanel/inputs/CitySelector.jsx
'use client';

import { Select } from 'antd';
import { useLocale, useTranslations } from 'next-intl';
import { useSelector } from 'react-redux';
const CitySelector = ({ value, onChange, placeholder = "اختر المدينة" }) => {
  const { city } = useSelector((state) => state.shared);
  const { selectedCityId } = useSelector((state) => state.rental);
  const locale = useLocale();
  const t = useTranslations();
  // استخدام القيمة المحفوظة من Redux إذا لم يتم تمرير قيمة
  const currentValue = value !== undefined ? value : selectedCityId;
  
  // Label للوصولية
  const ariaLabel = locale === 'en' 
    ? 'Select city' 
    : placeholder || 'اختر المدينة';

  return (
    <Select
      placeholder={placeholder}
      aria-label={ariaLabel}
      value={currentValue}
      onChange={onChange}
      options={city?.map(cityItem => ({
        value: cityItem.cityId,
        label: locale === 'en' ? cityItem.cityName : cityItem.cityArName
      })) || []}
      size="large"
      className="w-full !h-[50px]  text-sm  max-sm:!text-xs  max-sm:!h-[40px] [&_.ant-select-selector]:max-sm:!text-xs 
  border border-[#162A2B] rounded  "
    />
  );
};

export default CitySelector;
