// components/AdvancedRentalPanel/inputs/BranchSelector.jsx
'use client';

import useBranchesByCity from '@/hook/useBranchesByCity';
import { Select } from 'antd';
import { useLocale } from 'next-intl';
import { useSelector } from 'react-redux';

const BranchSelector = ({ selectedCityId, value, onChange, placeholder = "فرع الاستلام" }) => {
  const locale = useLocale();
  const { branches, loading, error } = useBranchesByCity(selectedCityId);
  const { selectedBranchId } = useSelector((state) => state.rental);
  
  // استخدام القيمة المحفوظة من Redux إذا لم يتم تمرير قيمة
  const currentValue = value !== undefined ? value : selectedBranchId;

  const branchOptions = branches.map(branch => ({
    value: branch.branchId,
    label: locale === 'en' ? branch.branchName : branch.branchArName 
  }));

  // Label للوصولية
  const ariaLabel = locale === 'en' 
    ? 'Select pickup branch' 
    : placeholder || 'فرع الاستلام';

  return (
    <div>
      <Select
        placeholder={placeholder}
        aria-label={ariaLabel}
        className="w-full !h-[50px]  text-sm max-sm:!h-[40px] max-sm:!text-xs  [&_.ant-select-selector]:max-sm:!text-xs border border-[#162A2B] rounded      "
        options={branchOptions}
        value={currentValue}
        onChange={onChange}
        loading={loading}
        size="large"
        disabled={!selectedCityId}
      />
      {error && (
        <div className="text-red-500 text-sm mt-1">
          {locale === 'en' ? 'Error loading branches' : 'خطأ في تحميل الفروع'}
        </div>
      )}
    </div>
  );
};

export default BranchSelector;
