import Image from "next/image";
import { useSelector } from "react-redux";
import carImage from '/public/assets/Images/test/Car.png';

const CarTypeSelector = ({ data, onSelectionChange, locale }) => {
    const { selectedCarTypes = [] } = useSelector((state) => state.rental)
    const isSelected = selectedCarTypes?.includes(data.typeId);

    const handleClick = () => {
        const newSelectionState = !isSelected;
        // إرسال التغيير للمكون الأب
        if (onSelectionChange) {
            onSelectionChange(data.typeId, newSelectionState);
        }
    };

    return (
        <div
            onClick={handleClick}
            className={`cursor-pointer p-4 rounded-lg transition-all duration-200 w-full h-[150px] max-md:h-32 flex flex-col justify-center items-center ${isSelected
                ? 'bg-main border-2 border-main shadow-md'
                : 'bg-white border-2 border-gray-200 hover:border-main hover:shadow-sm'
                }`}
        >
            <div className="flex justify-center items-center flex-col gap-3 w-full h-full">
                <div className="flex-1 flex items-center justify-center">
                    <Image 
                        src={data.icon || carImage} 
                        alt={locale === 'en' ? data.englishName : data.arabicName} 
                        width={150} 
                        height={150}
                        className="object-contain"
                    />
                </div>
                <span className={`text-sm font-bold   max-md:text-xs max-md:font-medium   text-center    ${isSelected ? 'text-white' : 'text-gray-700'
                    }`} style={{ fontSize: '14px', lineHeight: '1.2' }}>
                    {locale === 'en' ? data.englishName : data.arabicName}
                </span>
            </div>
        </div>
    );
};

export default CarTypeSelector;
