import { setDeliveryType } from '@/store/features/rental/rentalSlice';
import { Button } from 'antd';
import { useTranslations } from 'next-intl';
import { useDispatch, useSelector } from 'react-redux';

const PickupDeliverySelector = () => {
    const t = useTranslations();
    const dispatch = useDispatch();
    const { deliveryType } = useSelector((state) => state.rental);

    return (
        <div className="flex gap-2 main_content_tab_top">
            {/* Duration */}
            <Button
                className={`px-6 py-1 rounded-md text-sm shadow-sm ${deliveryType === 'branch' ? '!bg-main !text-white' : '!border-secondary !text-main'} 
                max-sm:!px-6 max-sm:!py-0.5 max-sm:!h-8 max-sm:!font-medium  max-sm:!text-xs`}
                onClick={() => dispatch(setDeliveryType('branch'))}
                size="large"
            >
                {t('pickup_from_branch')}
            </Button>
            {/* Delivery */}
            <Button
                className={`px-6 py-1 rounded-md text-sm shadow-sm ${deliveryType === 'delivery' ? '!bg-main !text-white' : '!border-secondary !text-main'}
                max-sm:!px-6 max-sm:!py-0.5  max-sm:!h-8 max-sm:!font-medium  max-sm:!text-xs`}
                onClick={() => dispatch(setDeliveryType('delivery'))}
                size="large"
            >
                {t('delivery')}
            </Button>
        </div>
    );
};

export default PickupDeliverySelector;
